***** Is Europe an optimal Political Area?                *****
***** Alberto Alesina, Guido Tabellini & Francesco Trebbi *****

***** Section I.A - I.B

clear
set more off

* Set output directory
cap mkdir "section1"
cap mkdir "appendix"

use "data/data_countries.dta", clear


* Define average growth and sd
xtset ccode year
sort ccode year
g gy = rrgdppc - l.rrgdppc
bys country : egen mgy_80_09 = mean(gy) if year < 2010
bys year: egen sdy = sd(rrgdp)

la var mgy_80_09 "Average GDP growth (1980 - 2009)"

* Figure 1
twoway tsline sdy if country =="Austria" & year < 2010, title("Sigma Convergence between countries (1980-2009)") ///
                  ytitle("SD of Log GDP per capita") subtitle("Standard Deviation in GDP per capita")
graph export "section1/figure_1.png", replace as(png)
***


* Figure 2
reg mgy_80_09 rrgdppc if year == 1980
avplots, m(none) mlabel(country_code) title("Beta Convergence 1980-2009") subtitle("Partial Regression Plot") ///
         xtitle("Log GDP per capita (1980)") ytitle("Average Growth (1980-2009)")
graph export "section1/figure_2.png", replace as(png)
***


* Figure A.1
use "data/gini.dta", clear
tsset year
tsline gini, title("Gini Coefficient") subtitle("EU (1985 - 2010)") xtitle(Year) ytitle(Gini Coefficient) ysca(r(0.28 0.34)) ylab(#4) ///
             note("Sample includes Denmark, Finland, France, Germany, Italy, Luxembourg, Netherlands,""Spain and UK" ///
             "Source: LIS - Luxembourg Income Study, individual data")
graph export "appendix/figure_A1.png", as(png) replace
***
